# Coaching Feedback Tool — Deployment Guide

This guide walks through deploying the Coaching Session Feedback tool, a web application that analyzes coaching session recordings and provides developmental feedback based on ICF Core Competencies.

---

## What This App Does

1. Students enter an access code (provided by instructor)
2. Students upload a video/audio recording of their coaching session
3. The app transcribes the conversation with speaker labels
4. AI analyzes the session against ICF competencies
5. Students receive feedback on strengths and growth areas
6. Recordings are automatically deleted after processing

---

## Prerequisites

- **Node.js** (version 18 or higher) — [Download here](https://nodejs.org/)
- **npm** (comes with Node.js)
- **AssemblyAI account** — [Sign up free](https://www.assemblyai.com/)
- **Vercel account** (for hosting) — [Sign up free](https://vercel.com/)

---

## Step 1: Get Your AssemblyAI API Key

1. Go to https://www.assemblyai.com/
2. Create a free account (or log in)
3. Go to your Dashboard
4. Copy your **API Key** (looks like a long string of letters and numbers)
5. Save this somewhere secure — you'll need it in Step 4

---

## Step 2: Install Vercel CLI

Open a terminal (Command Prompt on Windows, Terminal on Mac) and run:

```bash
npm install -g vercel
```

Verify it installed:

```bash
vercel --version
```

You should see a version number like `33.x.x`.

---

## Step 3: Deploy the App

1. **Unzip** the `coaching-feedback-app.zip` file

2. **Open terminal** and navigate to the unzipped folder:
   ```bash
   cd path/to/coaching-feedback-app
   ```

3. **Run the deploy command:**
   ```bash
   vercel
   ```

4. **Follow the prompts:**
   - "Set up and deploy?" → **Y** (Yes)
   - "Which scope?" → Select your account
   - "Link to existing project?" → **N** (No)
   - "What's your project's name?" → Enter a name like `coaching-feedback` (this becomes part of your URL)
   - "In which directory is your code located?" → Press **Enter** (current directory)

5. Vercel will deploy a preview. You'll see a URL like:
   ```
   https://coaching-feedback-abc123.vercel.app
   ```

---

## Step 4: Configure Environment Variables

The app needs two secret values to function. Add them in Vercel:

### Option A: Via Command Line

```bash
vercel env add ASSEMBLYAI_API_KEY
```
- Paste your AssemblyAI API key when prompted
- Select all environments: **Production**, **Preview**, **Development**

```bash
vercel env add ACCESS_CODES
```
- Enter comma-separated access codes for students, e.g.: `coach2024,winter2025,student1`
- Select all environments: **Production**, **Preview**, **Development**

### Option B: Via Vercel Dashboard

1. Go to https://vercel.com/dashboard
2. Click on your project
3. Go to **Settings** → **Environment Variables**
4. Add:
   | Name | Value | Environments |
   |------|-------|--------------|
   | `ASSEMBLYAI_API_KEY` | (your API key) | All |
   | `ACCESS_CODES` | `coach2024,winter2025` | All |

---

## Step 5: Deploy to Production

After adding environment variables, deploy the production version:

```bash
vercel --prod
```

You'll get your final production URL:
```
https://coaching-feedback.vercel.app
```

(Or `https://your-project-name.vercel.app`)

---

## Step 6: Test the Deployment

1. Open your production URL in a browser
2. Enter one of your access codes (e.g., `coach2024`)
3. Upload a short test audio/video file
4. Wait for processing (1-2 minutes for a short file)
5. Verify you receive feedback

---

## Sharing with Students

Provide students with:
1. **The URL**: `https://your-project-name.vercel.app`
2. **An access code**: One of the codes you set in `ACCESS_CODES`

You can create different codes for different cohorts to track usage.

---

## Managing Access Codes

To add or change access codes later:

1. Go to https://vercel.com/dashboard
2. Select your project
3. Go to **Settings** → **Environment Variables**
4. Edit the `ACCESS_CODES` variable
5. Click **Save**
6. Redeploy: Go to **Deployments** → click the three dots on the latest deployment → **Redeploy**

---

## Costs

| Service | Cost |
|---------|------|
| **Vercel hosting** | Free (generous limits for small-medium usage) |
| **AssemblyAI transcription** | ~$0.37 per hour of audio |
| **AssemblyAI analysis** | ~$0.05-0.10 per session |

**Example**: 30 students × 1-hour session each = ~$15 total

Monitor your AssemblyAI usage at: https://www.assemblyai.com/app/usage

---

## Troubleshooting

### "Invalid access code"
- Check that the code matches one in your `ACCESS_CODES` environment variable
- Codes are case-insensitive
- Make sure you redeployed after adding/changing codes

### "Service not configured"
- Verify `ASSEMBLYAI_API_KEY` is set in Vercel environment variables
- Redeploy after adding the variable

### "Upload limit reached"
- Users are limited to 5 uploads per hour (security feature)
- Wait an hour or adjust the limit in `api/upload.js`

### Processing seems stuck
- Hour-long files take 3-5 minutes to process
- Check the AssemblyAI dashboard for errors: https://www.assemblyai.com/app

### "Failed to fetch" error
- Make sure you're accessing the deployed URL, not opening the HTML file directly
- Check that all environment variables are set
- Try redeploying: `vercel --prod`

---

## File Structure Reference

```
coaching-feedback-app/
├── index.html          # The web interface students see
├── api/
│   ├── upload.js       # Handles file uploads (with rate limiting)
│   ├── transcribe.js   # Starts the transcription
│   ├── status.js       # Checks transcription progress
│   └── analyze.js      # Runs AI analysis + auto-deletes recording
├── package.json        # Project configuration
├── vercel.json         # Vercel settings
└── README.md           # Technical documentation
```

---

## Security Notes

- **API key** is stored securely on the server, never exposed to browsers
- **Recordings** are automatically deleted from AssemblyAI after analysis
- **Access codes** prevent unauthorized usage
- **Rate limiting** prevents abuse (5 uploads/hour per user)
- **File size** limited to 500MB

---

## Support Contacts

- **AssemblyAI documentation**: https://www.assemblyai.com/docs
- **Vercel documentation**: https://vercel.com/docs
- **AssemblyAI support**: support@assemblyai.com

---

## Quick Reference

| What | Where |
|------|-------|
| Your app URL | `https://[project-name].vercel.app` |
| Vercel dashboard | https://vercel.com/dashboard |
| AssemblyAI dashboard | https://www.assemblyai.com/app |
| Change access codes | Vercel → Project → Settings → Environment Variables |
| View API usage | https://www.assemblyai.com/app/usage |
