# Coaching Session Feedback Tool

A secure web app that transcribes coaching session recordings and provides developmental feedback based on ICF Core Competencies at the ACC level.

## What it does

1. Student enters access code (provided by instructor)
2. Student uploads an audio/video recording of their coaching session
3. AssemblyAI transcribes it with speaker labels (Coach / Client)
4. AssemblyAI's LeMUR analyzes the session against ICF competencies
5. Student receives warm, developmental feedback on strengths and growth areas
6. Recording is automatically deleted from servers after analysis

## Security Features

- **Access codes** — Only users with valid codes can use the tool
- **Rate limiting** — 5 uploads per hour per user (prevents abuse)
- **File validation** — Server-side type and size checks (500MB max)
- **Input sanitization** — All user inputs validated
- **Auto-delete** — Transcripts deleted from AssemblyAI after analysis
- **No storage** — Recordings are processed and discarded, not stored
- **API key protection** — Key never exposed to browser
- **Error sanitization** — Internal errors don't leak to users

## Deployment (5 minutes)

### Step 1: Get an AssemblyAI API Key

1. Go to [assemblyai.com](https://www.assemblyai.com/)
2. Create a free account
3. Copy your API key from the dashboard

### Step 2: Deploy to Vercel

**Option A: One-click deploy**

[![Deploy with Vercel](https://vercel.com/button)](https://vercel.com/new/clone?repository-url=https://github.com/YOUR_USERNAME/coaching-feedback-app)

**Option B: Manual deploy**

1. Install Vercel CLI: `npm i -g vercel`
2. From this folder, run: `vercel`
3. Follow the prompts to link/create a project
4. Add your environment variables:
   ```bash
   vercel env add ASSEMBLYAI_API_KEY
   # Paste your AssemblyAI key

   vercel env add ACCESS_CODES
   # Enter comma-separated codes, e.g.: coach2024,student123,demo
   ```
   Select all environments (Production, Preview, Development)
5. Deploy: `vercel --prod`

### Step 3: Share with students

1. Give students the URL: `https://your-project-name.vercel.app`
2. Give them an access code from your `ACCESS_CODES` list

## Environment Variables

| Variable | Required | Description |
|----------|----------|-------------|
| `ASSEMBLYAI_API_KEY` | Yes | Your AssemblyAI API key |
| `ACCESS_CODES` | No | Comma-separated access codes (e.g., `coach2024,student123`). If not set, tool is open to anyone. |

## Costs

- **Vercel hosting**: Free tier is generous
- **AssemblyAI**: ~$0.40-0.50 per hour of audio
  - Transcription: $0.37/hour
  - LeMUR analysis: ~$0.05-0.10 per session

For 30 students uploading one 1-hour session each: ~$15 in API costs.

## Local Development

1. Install Vercel CLI: `npm i -g vercel`
2. Create a `.env` file:
   ```
   ASSEMBLYAI_API_KEY=your_key_here
   ACCESS_CODES=testcode,demo
   ```
3. Run: `vercel dev`
4. Open http://localhost:3000
5. Enter access code: `testcode` or `demo`

## Customizing the Feedback

The feedback prompt is in `api/analyze.js`. You can modify it to:
- Change which competencies are emphasized
- Adjust the tone or structure of feedback
- Add program-specific criteria
- Include different coaching frameworks

## File Structure

```
coaching-feedback-app/
├── index.html          # Frontend (access code, upload UI, results)
├── api/
│   ├── upload.js       # Secure file upload with rate limiting
│   ├── transcribe.js   # Starts transcription job
│   ├── status.js       # Polls transcription status
│   └── analyze.js      # Runs LeMUR analysis + auto-delete
├── package.json
├── vercel.json         # Vercel configuration
└── README.md
```

## Troubleshooting

**"Invalid access code"**: Check that the code matches one in your `ACCESS_CODES` environment variable (case-insensitive).

**"Upload limit reached"**: Users are limited to 5 uploads per hour. Wait and try again.

**"Service not configured"**: Make sure `ASSEMBLYAI_API_KEY` is set in Vercel environment variables and you've redeployed.

**"File too large"**: Maximum file size is 500MB. Try compressing the video or extracting just the audio.

**Transcription taking forever**: Hour-long files take 3-5 minutes. The progress indicator will update.

## Privacy & Data Handling

- Recordings are uploaded directly to AssemblyAI for processing
- Transcripts are automatically deleted from AssemblyAI after analysis
- No recordings or transcripts are stored on Vercel servers
- Access codes are stored only in the user's browser session (cleared on tab close)
- Server logs only record timestamps and file sizes (no content)
